<?php
/* --------------------------------------------------------------
  OnGetSellingUnitEanEvent.php 2020-02-21
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitEanEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Ean;
use ProductDataInterface;

/**
 * Class OnGetSellingUniEanEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetSellingUnitEanEvent extends OnGetProductEanEvent implements OnGetSellingUnitEanEventInterface
{
    /**
     * OnGetSellingUnitEanEvent constructor.
     *
     * @param ProductDataInterface                  $product
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param LanguageId                            $languageId
     * @param Ean                                   $ean
     */
    public function __construct(
        ProductDataInterface $product,
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        LanguageId $languageId,
        Ean $ean
    ) {
        $this->product    = $product;
        $this->productId  = $productId;
        $this->modifiers  = $modifiers;
        $this->languageId = $languageId;
        $this->ean        = $ean;
    }
}